/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world;

import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Map;
import me.jellysquid.mods.sodium.client.util.math.ChunkSectionPos;
import me.jellysquid.mods.sodium.client.world.SodiumBlockAccess;
import me.jellysquid.mods.sodium.client.world.biome.BiomeColorCache;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSection;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class WorldSlice
implements SodiumBlockAccess {
    private static final int SECTION_BLOCK_LENGTH = 16;
    private static final int SECTION_BLOCK_COUNT = 4096;
    private static final int NEIGHBOR_BLOCK_RADIUS = 2;
    private static final int NEIGHBOR_CHUNK_RADIUS = MathHelper.func_154354_b((int)2, (int)16) >> 4;
    private static final int SECTION_LENGTH = 1 + NEIGHBOR_CHUNK_RADIUS * 2;
    private static final int TABLE_LENGTH = MathHelper.func_151236_b((int)SECTION_LENGTH);
    private static final int TABLE_BITS = Integer.bitCount(TABLE_LENGTH - 1);
    private static final int SECTION_TABLE_ARRAY_SIZE = TABLE_LENGTH * TABLE_LENGTH * TABLE_LENGTH;
    private final World world;
    private WorldType worldType;
    private final int defaultSkyLightValue;
    private final IBlockState[][] blockStatesArrays;
    private ClonedChunkSection[] sections;
    private Biome[][] biomeCaches;
    private final Map<BiomeColorHelper.ColorResolver, BiomeColorCache> biomeColorCaches = new Reference2ObjectOpenHashMap();
    private BiomeColorHelper.ColorResolver prevColorResolver;
    private BiomeColorCache prevColorCache;
    private int baseX;
    private int baseY;
    private int baseZ;
    private ChunkSectionPos origin;
    private StructureBoundingBox volume;

    public static ChunkRenderContext prepare(World world, ChunkSectionPos origin, ClonedChunkSectionCache sectionCache) {
        Chunk chunk = world.func_72964_e(origin.func_177958_n(), origin.func_177952_p());
        ExtendedBlockStorage section = chunk.func_76587_i()[origin.func_177956_o()];
        if (section == null || section.func_76663_a()) {
            return null;
        }
        StructureBoundingBox volume = new StructureBoundingBox(origin.getMinX() - 2, origin.getMinY() - 2, origin.getMinZ() - 2, origin.getMaxX() + 2, origin.getMaxY() + 2, origin.getMaxZ() + 2);
        int minChunkX = origin.func_177958_n() - NEIGHBOR_CHUNK_RADIUS;
        int minChunkY = origin.func_177956_o() - NEIGHBOR_CHUNK_RADIUS;
        int minChunkZ = origin.func_177952_p() - NEIGHBOR_CHUNK_RADIUS;
        int maxChunkX = origin.func_177958_n() + NEIGHBOR_CHUNK_RADIUS;
        int maxChunkY = origin.func_177956_o() + NEIGHBOR_CHUNK_RADIUS;
        int maxChunkZ = origin.func_177952_p() + NEIGHBOR_CHUNK_RADIUS;
        ClonedChunkSection[] sections = new ClonedChunkSection[SECTION_TABLE_ARRAY_SIZE];
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                for (int chunkY = minChunkY; chunkY <= maxChunkY; ++chunkY) {
                    sections[WorldSlice.getLocalSectionIndex((int)(chunkX - minChunkX), (int)(chunkY - minChunkY), (int)(chunkZ - minChunkZ))] = sectionCache.acquire(chunkX, chunkY, chunkZ);
                }
            }
        }
        return new ChunkRenderContext(origin, sections, volume);
    }

    public WorldSlice(World world) {
        this.world = world;
        this.worldType = world.func_175624_G();
        this.defaultSkyLightValue = this.world.field_73011_w.func_191066_m() ? EnumSkyBlock.SKY.field_77198_c : 0;
        this.sections = new ClonedChunkSection[SECTION_TABLE_ARRAY_SIZE];
        this.blockStatesArrays = new IBlockState[SECTION_TABLE_ARRAY_SIZE][];
        this.biomeCaches = new Biome[SECTION_TABLE_ARRAY_SIZE][256];
        for (int x = 0; x < SECTION_LENGTH; ++x) {
            for (int y = 0; y < SECTION_LENGTH; ++y) {
                for (int z = 0; z < SECTION_LENGTH; ++z) {
                    int i = WorldSlice.getLocalSectionIndex(x, y, z);
                    this.blockStatesArrays[i] = new IBlockState[4096];
                    Arrays.fill(this.blockStatesArrays[i], Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    public void copyData(ChunkRenderContext context) {
        this.origin = context.getOrigin();
        this.sections = context.getSections();
        this.volume = context.getVolume();
        this.prevColorCache = null;
        this.prevColorResolver = null;
        this.biomeColorCaches.clear();
        this.baseX = this.origin.func_177958_n() - NEIGHBOR_CHUNK_RADIUS << 4;
        this.baseY = this.origin.func_177956_o() - NEIGHBOR_CHUNK_RADIUS << 4;
        this.baseZ = this.origin.func_177952_p() - NEIGHBOR_CHUNK_RADIUS << 4;
        for (int x = 0; x < SECTION_LENGTH; ++x) {
            for (int y = 0; y < SECTION_LENGTH; ++y) {
                for (int z = 0; z < SECTION_LENGTH; ++z) {
                    int idx = WorldSlice.getLocalSectionIndex(x, y, z);
                    ClonedChunkSection section = this.sections[idx];
                    this.biomeCaches[idx] = section.getBiomeData();
                    this.unpackBlockData(this.blockStatesArrays[idx], section, context.getVolume());
                }
            }
        }
    }

    private void unpackBlockData(IBlockState[] states, ClonedChunkSection section, StructureBoundingBox box) {
        if (this.origin.equals((Object)section.getPosition())) {
            this.unpackBlockDataZ(states, section);
        } else {
            this.unpackBlockDataR(states, section, box);
        }
    }

    private static void copyBlocks(IBlockState[] blocks, ClonedChunkSection section, int minBlockY, int maxBlockY, int minBlockZ, int maxBlockZ, int minBlockX, int maxBlockX) {
        for (int y = minBlockY; y <= maxBlockY; ++y) {
            for (int z = minBlockZ; z <= maxBlockZ; ++z) {
                for (int x = minBlockX; x <= maxBlockX; ++x) {
                    int blockIdx = WorldSlice.getLocalBlockIndex(x & 0xF, y & 0xF, z & 0xF);
                    blocks[blockIdx] = section.getBlockState(x & 0xF, y & 0xF, z & 0xF);
                }
            }
        }
    }

    private void unpackBlockDataR(IBlockState[] states, ClonedChunkSection section, StructureBoundingBox box) {
        ChunkSectionPos pos = section.getPosition();
        int minBlockX = Math.max(box.field_78897_a, pos.getMinX());
        int maxBlockX = Math.min(box.field_78893_d, pos.getMaxX());
        int minBlockY = Math.max(box.field_78895_b, pos.getMinY());
        int maxBlockY = Math.min(box.field_78894_e, pos.getMaxY());
        int minBlockZ = Math.max(box.field_78896_c, pos.getMinZ());
        int maxBlockZ = Math.min(box.field_78892_f, pos.getMaxZ());
        WorldSlice.copyBlocks(states, section, minBlockY, maxBlockY, minBlockZ, maxBlockZ, minBlockX, maxBlockX);
    }

    private void unpackBlockDataZ(IBlockState[] states, ClonedChunkSection section) {
        ChunkSectionPos pos = section.getPosition();
        int minBlockX = pos.getMinX();
        int maxBlockX = pos.getMaxX();
        int minBlockY = pos.getMinY();
        int maxBlockY = pos.getMaxY();
        int minBlockZ = pos.getMinZ();
        int maxBlockZ = pos.getMaxZ();
        WorldSlice.copyBlocks(states, section, minBlockY, maxBlockY, minBlockZ, maxBlockZ, minBlockX, maxBlockX);
    }

    private static boolean blockBoxContains(StructureBoundingBox box, int x, int y, int z) {
        return x >= box.field_78897_a && x <= box.field_78893_d && y >= box.field_78895_b && y <= box.field_78894_e && z >= box.field_78896_c && z <= box.field_78892_f;
    }

    public IBlockState func_180495_p(BlockPos pos) {
        return this.getBlockState(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public boolean func_175623_d(BlockPos pos) {
        IBlockState state = this.func_180495_p(pos);
        return state.func_177230_c().isAir(state, (IBlockAccess)this, pos);
    }

    public IBlockState getBlockState(int x, int y, int z) {
        if (!WorldSlice.blockBoxContains(this.volume, x, y, z)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        int relX = x - this.baseX;
        int relY = y - this.baseY;
        int relZ = z - this.baseZ;
        return this.blockStatesArrays[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)][WorldSlice.getLocalBlockIndex(relX & 0xF, relY & 0xF, relZ & 0xF)];
    }

    public IBlockState getBlockStateRelative(int x, int y, int z) {
        return this.blockStatesArrays[WorldSlice.getLocalSectionIndex(x >> 4, y >> 4, z >> 4)][WorldSlice.getLocalBlockIndex(x & 0xF, y & 0xF, z & 0xF)];
    }

    public TileEntity func_175625_s(BlockPos pos) {
        return this.getBlockEntity(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public TileEntity getBlockEntity(int x, int y, int z) {
        if (!WorldSlice.blockBoxContains(this.volume, x, y, z)) {
            return null;
        }
        int relX = x - this.baseX;
        int relY = y - this.baseY;
        int relZ = z - this.baseZ;
        return this.sections[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)].getBlockEntity(relX & 0xF, relY & 0xF, relZ & 0xF);
    }

    public int func_175626_b(BlockPos pos, int ambientLight) {
        if (!WorldSlice.blockBoxContains(this.volume, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
            return this.defaultSkyLightValue << 20 | ambientLight << 4;
        }
        int i = this.getLightFromNeighborsFor(EnumSkyBlock.SKY, pos);
        int j = this.getLightFromNeighborsFor(EnumSkyBlock.BLOCK, pos);
        if (j < ambientLight) {
            j = ambientLight;
        }
        return i << 20 | j << 4;
    }

    private int getLightFor(EnumSkyBlock type, int relX, int relY, int relZ) {
        ClonedChunkSection section = this.sections[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)];
        return section.getLightLevel(relX & 0xF, relY & 0xF, relZ & 0xF, type);
    }

    private int getLightFromNeighborsFor(EnumSkyBlock type, BlockPos pos) {
        int relZ;
        int relY;
        if (!this.world.field_73011_w.func_191066_m() && type == EnumSkyBlock.SKY) {
            return this.defaultSkyLightValue;
        }
        int relX = pos.func_177958_n() - this.baseX;
        IBlockState state = this.getBlockStateRelative(relX, relY = pos.func_177956_o() - this.baseY, relZ = pos.func_177952_p() - this.baseZ);
        if (!state.func_185916_f()) {
            return this.getLightFor(type, relX, relY, relZ);
        }
        int west = this.getLightFor(type, relX - 1, relY, relZ);
        int east = this.getLightFor(type, relX + 1, relY, relZ);
        int up = this.getLightFor(type, relX, relY + 1, relZ);
        int down = this.getLightFor(type, relX, relY - 1, relZ);
        int north = this.getLightFor(type, relX, relY, relZ + 1);
        int south = this.getLightFor(type, relX, relY, relZ - 1);
        if (east > west) {
            west = east;
        }
        if (up > west) {
            west = up;
        }
        if (down > west) {
            west = down;
        }
        if (north > west) {
            west = north;
        }
        if (south > west) {
            west = south;
        }
        return west;
    }

    public Biome func_180494_b(BlockPos pos) {
        int z2;
        int x2 = pos.func_177958_n() - this.baseX >> 4;
        ClonedChunkSection section = this.sections[WorldSlice.getLocalChunkIndex(x2, z2 = pos.func_177952_p() - this.baseZ >> 4)];
        if (section != null) {
            return section.getBiomeForNoiseGen(pos.func_177958_n() & 0xF, pos.func_177952_p() & 0xF);
        }
        return Biomes.field_76772_c;
    }

    @Override
    public int getBlockTint(BlockPos pos, BiomeColorHelper.ColorResolver resolver) {
        BiomeColorCache cache;
        if (!WorldSlice.blockBoxContains(this.volume, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
            return resolver.func_180283_a(Biomes.field_76772_c, pos);
        }
        if (this.prevColorResolver == resolver) {
            cache = this.prevColorCache;
        } else {
            cache = this.biomeColorCaches.get(resolver);
            if (cache == null) {
                cache = new BiomeColorCache(resolver, this);
                this.biomeColorCaches.put(resolver, cache);
            }
            this.prevColorResolver = resolver;
            this.prevColorCache = cache;
        }
        return cache.getBlendedColor(pos);
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        IBlockState state = this.func_180495_p(pos);
        return state.func_177230_c().func_176211_b(state, (IBlockAccess)this, pos, direction);
    }

    public WorldType func_175624_G() {
        return this.worldType;
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        return this.func_180495_p(pos).isSideSolid((IBlockAccess)this, pos, side);
    }

    public Biome getBiome(int x, int y, int z) {
        int relX = x - this.baseX;
        int relY = y - this.baseY;
        int relZ = z - this.baseZ;
        int idx = WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4);
        if (idx < 0 || idx >= this.biomeCaches.length) {
            return Biomes.field_76772_c;
        }
        return this.biomeCaches[idx][(z & 0xF) << 4 | x & 0xF];
    }

    public ChunkSectionPos getOrigin() {
        return this.origin;
    }

    public float getBrightness(EnumFacing direction, boolean shaded) {
        if (!shaded) {
            return !this.world.field_73011_w.func_191066_m() ? 0.9f : 1.0f;
        }
        return LightUtil.diffuseLight((EnumFacing)direction);
    }

    public static int getLocalBlockIndex(int x, int y, int z) {
        return y << 8 | z << 4 | x;
    }

    public static int getLocalSectionIndex(int x, int y, int z) {
        return y << TABLE_BITS << TABLE_BITS | z << TABLE_BITS | x;
    }

    public static int getLocalChunkIndex(int x, int z) {
        return z << TABLE_BITS | x;
    }
}

